/*
 * Decompiled with CFR 0.152.
 */
package com.hyppr.me.samples;

import javax.microedition.rms.RecordStore;

public class HypprRecordStore {
    private RecordStore rs = null;
    private String rsName = null;
    static final String DEFAULT_REC_STORE = "hypprdb";

    public HypprRecordStore() {
        try {
            if (this.rsName == null) {
                this.rsName = DEFAULT_REC_STORE;
                this.rs = RecordStore.openRecordStore((String)this.rsName, (boolean)true);
            }
        }
        catch (Exception e) {
            this.db(e.toString());
        }
    }

    public void close() {
        try {
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            this.db(e.toString());
        }
    }

    public void delete() {
        if (RecordStore.listRecordStores() != null) {
            try {
                RecordStore.deleteRecordStore((String)this.rsName);
            }
            catch (Exception e) {
                this.db(e.toString());
            }
        }
    }

    public void writeRecord(String str) {
        byte[] rec = str.getBytes();
        try {
            this.rs.addRecord(rec, 0, rec.length);
        }
        catch (Exception e) {
            this.db(e.toString());
        }
    }

    public void readRecords() {
        try {
            byte[] recData = new byte[5];
            for (int i = 1; i <= this.rs.getNumRecords(); ++i) {
                if (this.rs.getRecordSize(i) > recData.length) {
                    recData = new byte[this.rs.getRecordSize(i)];
                }
                int len = this.rs.getRecord(i, recData, 0);
                System.out.println("Record #" + i + ": " + new String(recData, 0, len));
                System.out.println("------------------------------");
            }
        }
        catch (Exception e) {
            this.db(e.toString());
        }
    }

    public static void TestReadWrite() {
        HypprRecordStore rs = new HypprRecordStore();
        System.out.println("TEST RECORD STORE");
        System.out.println("-----------------");
        rs.writeRecord("J2ME and MIDP");
        rs.writeRecord("Wireless Technology");
        rs.readRecords();
        rs.close();
        rs.delete();
    }

    private void db(String str) {
        System.err.println("Msg: " + str);
    }
}

