/*
 * Decompiled with CFR 0.152.
 */
package com.hyppr.me.samples;

import com.hyppr.me.samples.Book;
import com.hyppr.me.samples.HypprRecordStore;
import com.hyppr.me.samples.PhoneRec;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class PhoneListReader
extends MIDlet
implements CommandListener {
    private boolean midletPaused = false;
    Form mainForm = new Form("SampleJ2MEXML");
    static final String catalogLoc = "book.xml";
    static final String phoneListLoc = "0870.xml";
    Vector phonesVector = new Vector();
    StringItem resultItem = new StringItem("", "");
    private static final Command xmlCommand = new Command("Get XML Data", 4, 1);
    private static final Command exitCommand = new Command("Exit", 7, 1);
    private HypprRecordStore rs;

    public PhoneListReader() {
        this.mainForm.append((Item)this.resultItem);
        this.mainForm.addCommand(xmlCommand);
        this.mainForm.addCommand(exitCommand);
        this.mainForm.setCommandListener((CommandListener)this);
    }

    private void initialize() {
    }

    public void startMIDlet() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mainForm);
        new ReadXML().start();
        this.openRMS();
    }

    public void resumeMIDlet() {
    }

    public void switchDisplayable(Alert alert, Displayable nextDisplayable) {
        Display display = this.getDisplay();
        if (alert == null) {
            display.setCurrent(nextDisplayable);
        } else {
            display.setCurrent(alert, nextDisplayable);
        }
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void exitMIDlet() {
        this.switchDisplayable(null, null);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void startApp() {
        if (this.midletPaused) {
            this.resumeMIDlet();
        } else {
            this.initialize();
            this.startMIDlet();
        }
        this.midletPaused = false;
    }

    public void pauseApp() {
        this.midletPaused = true;
    }

    public void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable d) {
        StringBuffer sb = new StringBuffer();
        if (d == this.mainForm && c == exitCommand) {
            this.exitMIDlet();
        }
        if (c == xmlCommand) {
            for (int i = 0; i < this.phonesVector.size(); ++i) {
                PhoneRec phone = (PhoneRec)this.phonesVector.elementAt(i);
                sb.append("Name: ");
                sb.append(phone.getCoName());
                sb.append("\n");
                sb.append("NGN: ");
                sb.append(phone.getNonGeoNumber());
                sb.append("\n");
                sb.append("Geo num: ");
                sb.append(phone.getBestGeoNumber());
                sb.append("\n");
                sb.append("\n");
            }
            this.resultItem.setLabel("Phone list");
            this.resultItem.setText(sb.toString());
        }
    }

    public void processDocument(KXmlParser kxp) throws XmlPullParserException, IOException {
        int eventType = kxp.getEventType();
        do {
            if (eventType != 0) {
                if (eventType != 1) {
                    if (eventType == 2) {
                        this.processStartElement(kxp);
                    } else if (eventType == 3) {
                        this.processEndElement(kxp);
                    } else if (eventType == 4) {
                        this.processText(kxp);
                    }
                }
            }
            eventType = kxp.next();
        } while (eventType != 1);
    }

    private void processStartElement(KXmlParser p) {
        if (p.getName().equals("Row")) {
            this.processRow(p);
        }
    }

    private void processEndElement(KXmlParser p) {
    }

    private void processText(KXmlParser p) {
    }

    private void processRow(KXmlParser parser) {
        PhoneRec phoneRec = new PhoneRec();
        try {
            int eventType;
            System.out.println("    processRow()");
            System.out.println("    Type: " + parser.getEventType());
            System.out.println("    Name: " + parser.getName());
            System.out.println("    Text: " + parser.getText());
            do {
                eventType = parser.nextTag();
                System.out.println("nextTag()");
                System.out.println("Type:" + eventType + ", getName(): " + parser.getName());
            } while (eventType != 2 || !parser.getName().equals("Data"));
            phoneRec.setCoName(parser.nextText());
            do {
                eventType = parser.nextTag();
                System.out.println("nextTag()");
                System.out.println("Type:" + eventType + ", getName(): " + parser.getName());
            } while (eventType != 2 || !parser.getName().equals("Data"));
            phoneRec.setNonGeoNumber(parser.nextText());
            do {
                eventType = parser.nextTag();
                System.out.println("nextTag()");
                System.out.println("Type:" + eventType + ", getName(): " + parser.getName());
            } while (eventType != 2 || !parser.getName().equals("Data"));
            phoneRec.setBestGeoNumber(parser.nextText());
            do {
                eventType = parser.nextTag();
                System.out.println("nextTag()");
                System.out.println("Type:" + eventType + ", getName(): " + parser.getName());
            } while (eventType != 2 || !parser.getName().equals("Data"));
            phoneRec.setOtherInfo(parser.nextText());
            this.phonesVector.addElement(phoneRec);
        }
        catch (XmlPullParserException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void openRMS() {
        try {
            HypprRecordStore.TestReadWrite();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void readXMLData(KXmlParser parser) throws XmlPullParserException, IOException {
        parser.require(2, null, "title");
        Book book = new Book();
        while (parser.nextTag() != 3) {
            parser.require(2, null, null);
            String name = parser.getName();
            String text = parser.nextText();
            System.out.println("<" + name + ">" + text);
            if (name.equals("name")) {
                book.setName(text);
            } else if (name.equals("description")) {
                book.setDescription(text);
            } else if (name.equals("author")) {
                book.setAuthor(text);
            } else if (name.equals("rating")) {
                book.setRating(text);
            } else if (name.equals("available")) {
                book.setAvailable(text);
            }
            parser.require(3, null, name);
        }
        parser.require(3, null, "title");
    }

    class ReadXML
    extends Thread {
        ReadXML() {
        }

        public void run() {
            try {
                InputStream in = this.getClass().getResourceAsStream(PhoneListReader.phoneListLoc);
                KXmlParser parser = new KXmlParser();
                parser.setInput(new InputStreamReader(in));
                PhoneListReader.this.processDocument(parser);
            }
            catch (Exception e) {
                e.printStackTrace();
                PhoneListReader.this.resultItem.setLabel("Error:");
                PhoneListReader.this.resultItem.setText(e.toString());
            }
        }
    }
}

